#ifndef _PHY_TIME_H_
#define _PHY_TIME_H_

/************************************************************************************
*************************************************************************************
* Includes
*************************************************************************************
************************************************************************************/
#include "EmbeddedTypes.h"
#include "PortConfig.h"

/************************************************************************************
*************************************************************************************
* Public Macros and Definitions
*************************************************************************************
************************************************************************************/
#define gPhyTimerCtrl  TPM2_SC

#define gPhyTimerCnt   TPM2_CNT

#define gPhy_IRQ_NUM_c              (INT_TPM2-16)
#define gPhy_InterruptPriority_c    (0xau)

#define gPhy_SIM_SCGC_REG_c         SIM_SCGC6
#define gPhy_SIM_SCGC_TPM2_Mask_c   SIM_SCGC6_TPM2_MASK

#define gTimerCtrl_Prescale1_c     0x00    /* For prescale Value of 1   */
#define gTimerCtrl_Prescale2_c     0x01    /* For prescale Value of 2   */
#define gTimerCtrl_Prescale4_c     0x02    /* For prescale Value of 4   */
#define gTimerCtrl_Prescale8_c     0x03    /* For prescale Value of 8   */
#define gTimerCtrl_Prescale16_c    0x04    /* For prescale Value of 16  */
#define gTimerCtrl_Prescale32_c    0x05    /* For prescale Value of 32  */
#define gTimerCtrl_Prescale64_c    0x06    /* For prescale Value of 64  */
#define gTimerCtrl_Prescale128_c   0x07    /* For prescale Value of 128 */

#define gTimerCtrl_TOF_c           0x80u    /* Timer overflow flag. (RO) */
#define gTimerCtrl_TOIE_c          0x40u    /* Timer overflow interrupt enable. (RW) */
#define gTimerCtrl_CPWMS_c         0x20u    /* Center-aliged PWM select. (RW) */
#define gTimerCtrl_CLKSB_c         0x10u    /* Clock source, high bit. (RW) */
#define gTimerCtrl_CLKSA_c         0x08u    /* Clock source, low bit. (RW) */
#define gTimerCtrl_PS2_c           0x04u    /* Prescale divisor select, high bit. (RW) */
#define gTimerCtrl_PS1_c           0x02u    /* Prescale divisor select, middle bit. (RW) */
#define gTimerCtrl_PS0_c           0x01u    /* Prescale divisor select, low bit. (RW) */


#define gPhyTimerMod          TPM2_MOD
#define gPhyEventTriggerCtrl  TPM2_C0SC
#define gPhyEventTriggerCmp   TPM2_C0V
#define gPhyEventTimeoutCtrl  TPM2_C1SC
#define gPhyEventTimeoutCmp   TPM2_C1V
#define gPhyTimerStatus       TPM2_STATUS


#define gTPM_STATUS_CH0F_MASK_c      0x80u              
#define gTPM_STATUS_CH1F_MASK_c      0x80u               
#define gTPM_STATUS_CHIE_MASK_c      0x40u              


#define gEventTimerCtrl_F_c           TPM_SC_TOF_MASK     /* Overflow flag. */
#define gEventTimerCtrl_IE_c          TPM_SC_TOIE_MASK    /* Interrupt enable. */
#define gEventTimerCtrl_MSB_c         TPM_CnSC_MSB_MASK    /* Mode select bit B. */
#define gEventTimerCtrl_MSA_c         TPM_CnSC_MSA_MASK    /* Mode select bit A. */
#define gEventTimerCtrl_ELSB_c        TPM_CnSC_ELSB_MASK    /* Edge/level select high bit. */
#define gEventTimerCtrl_ELSA_c        TPM_CnSC_ELSA_MASK    /* Edge/level select low bit. */

#define gPhyTimerCtrl_ClockSource_c  gTimerCtrl_CLKSA_c
#define gPhyTimerCtrl_Prescaler_c       gTimerCtrl_Prescale32_c    

// configure timer in output compare mode, software compare only
#define PhyEventTriggerInit()\
  gPhyEventTriggerCtrl = gEventTimerCtrl_MSA_c;
#define PhyTimeDisableEventTrigger()\
  gPhyEventTriggerCtrl &= ~(gEventTimerCtrl_IE_c);      
  
#define PhyEventTimeoutInit()\
  gPhyEventTimeoutCtrl = gEventTimerCtrl_MSA_c;
#define PhyTimeDisableEventTimeout()\
    gPhyEventTimeoutCtrl &= ~(gEventTimerCtrl_IE_c);      
  


#define PhyTimerStart()\
        SIM_SOPT2|= SIM_SOPT2_TPMSRC(1); \
        gPhy_SIM_SCGC_REG_c|=SIM_SCGC6_TPM2_MASK;\
        gPhyTimerCtrl = 0x00;\
        gPhyTimerCnt = 0x00;\
        gPhyTimerMod = 0xBFFF;\
        /* Enables the interrupts corresponding to Timer_2 driver */\
        NVIC_EnableIRQ(gPhy_IRQ_NUM_c);\
        gPhyTimerCtrl |= (gPhyTimerCtrl_ClockSource_c | gPhyTimerCtrl_Prescaler_c  | gTimerCtrl_TOIE_c);

/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/
        
typedef union phyEvent32BitTimer_tag
{
  uint32_t longAccess;
  uint16_t wordAccess[2];
  uint8_t  byteAccess[4];                                                      
} phyEvent32BitTimer_t;

/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

void PhyTimeReadClock(phyEvent32BitTimer_t * pTime);
void PhyTimeSetEventTimeout(uint32_t pEndtime);
void PhyTimeSetEventTrigger(uint32_t pStartTime);
void PhyTimeEventTrigger_Handler(void);
void PhyTimeEventTimeout_Handler(void);
void PhyTimeOverFlow_Handler(void);

#endif /* _PHY_TIME_H_ */
